/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.eventhandlers.GiveRingOfFartEventHandlers;
import net.yezon.theabyss.eventhandlers.GiveRingOfFireworkEventHandlers;
import net.yezon.theabyss.eventhandlers.PXCreativeEventHandlers;
import net.yezon.theabyss.eventhandlers.PXOpSwordEventHandlers;
import net.yezon.theabyss.eventhandlers.PXSpectatorEventHandlers;
import net.yezon.theabyss.eventhandlers.PXSurvivalEventHandlers;
import net.yezon.theabyss.eventhandlers.PatreonDeathParticleEventHandlers;
import net.yezon.theabyss.eventhandlers.PatreonFireworkOnJoinEventHandlers;
import net.yezon.theabyss.eventhandlers.PatreonGetDisc1EventHandlers;
import net.yezon.theabyss.eventhandlers.PatreonGetDisc2EventHandlers;
import net.yezon.theabyss.eventhandlers.PatreonWalkParticlesEventHandlers;
import net.yezon.theabyss.world.inventory.PatreonScreenMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PatreonScreenButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PatreonScreenButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PatreonScreenButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PatreonScreenButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PatreonScreenButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PatreonScreenButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = PatreonScreenMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PatreonGetDisc1EventHandlers.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            PatreonGetDisc2EventHandlers.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            PatreonFireworkOnJoinEventHandlers.execute((Entity)entity);
        }
        if (buttonID == 3) {
            PatreonDeathParticleEventHandlers.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GiveRingOfFireworkEventHandlers.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            PatreonWalkParticlesEventHandlers.execute((Entity)entity);
        }
        if (buttonID == 6) {
            GiveRingOfFartEventHandlers.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            PXCreativeEventHandlers.execute((Entity)entity);
        }
        if (buttonID == 8) {
            PXSurvivalEventHandlers.execute((Entity)entity);
        }
        if (buttonID == 9) {
            PXSpectatorEventHandlers.execute((Entity)entity);
        }
        if (buttonID == 10) {
            PXOpSwordEventHandlers.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheabyssMod.addNetworkMessage(PatreonScreenButtonMessage.class, PatreonScreenButtonMessage::buffer, PatreonScreenButtonMessage::new, PatreonScreenButtonMessage::handler);
    }
}

